'Para formatacao de strings nos eixos graficos:
#include once "string.bi" 
'Para leitura de coordenadas da tela com o mouse:
#include once "LibMouse.bi"


'Declarao de variveis na biblioteca grfica (Graficos.bas ou Graficos.bi), a ser declarada antes
'dos procedimentos:
''
'UDT: "User Defined Type" ou "Tipo Definido pelo Usuario" para
'encapsular variveis de diferentes tipos
TYPE limitesDoGrafico
    'Coords world
    DIM wxMin AS DOUBLE
    DIM wxMax AS DOUBLE
    DIM wyMin AS DOUBLE
    DIM wyMax AS DOUBLE
    'Coords view
    DIM vxMin AS INTEGER
    DIM vxMax AS INTEGER
    DIM vyMin AS INTEGER
    DIM vyMax AS INTEGER
    'Tamanho do caracter em pixeis
    DIM charSize AS INTEGER
END TYPE

'Titulos do grafico e dos eixos
TYPE titulosDoGrafico
    DIM grafico AS STRING
    DIM eixoX AS STRING
    DIM eixoY AS STRING
END TYPE

'Declaracao dos procedimentos (Subrotinas e funcoes)
DECLARE FUNCTION wxTOvx (BYREF wx AS DOUBLE) AS INTEGER
DECLARE FUNCTION wyTOvy (BYREF wy AS DOUBLE) AS INTEGER
DECLARE FUNCTION vxTOwx (BYREF vx AS INTEGER) AS DOUBLE
DECLARE FUNCTION vyTOwy (BYREF vy AS INTEGER) AS DOUBLE
DECLARE SUB InicializaCoordsView
DECLARE SUB InicializaCoordsWorld (BYVAL n AS INTEGER, x() AS DOUBLE, y() AS DOUBLE)
DECLARE SUB InicializaFatores
DECLARE SUB PlotarPontos (BYVAL n AS INTEGER, x() AS DOUBLE, y() AS DOUBLE, BYVAL cor AS INTEGER, BYVAL flagLinhaUnindoPontos AS INTEGER, BYVAL titulos AS titulosDoGrafico)
DECLARE SUB colocarTicsERotulos (BYREF numeroDeDivisoesNosEixos AS INTEGER)
DECLARE SUB colocarTitulos(BYVAL titulos AS titulosDoGrafico)
DECLARE SUB GraficoDeReta (BYVAL CoefLinear AS DOUBLE, BYVAL CoefAngular AS DOUBLE, BYVAL cor AS INTEGER)
DECLARE SUB LerCoordenadasComMouse



'A varivel global lg encapsula as variveis limites do grfico acima:
DIM SHARED lg AS limitesDoGrafico
''
'Fatores para inicializacao da tela (variaveis globais)
DIM SHARED fatorWxVx AS DOUBLE
DIM SHARED fatorWyVy AS DOUBLE
'----------------------------------------------------------------------------------------------

'---------------------------------------------------------------------------------------------------
'As seguintes FUNCTIONs devem ser implementadas, para se converter coordenadas
'world <---> view: wx <---> vx e wy <---> vy:
'---------------------------------------------------------------------------------------------------
FUNCTION wxTOvx (BYREF wx AS DOUBLE) AS INTEGER
    'Converte coordenada wx em coordenada vx
    WITH lg
        DIM vx AS INTEGER
        vx = CINT( (wx - .wxMin) * fatorWxVx + .vxMin)
        RETURN vx
    END WITH
END FUNCTION
'---------------------------------------------------------------------------------------------------
FUNCTION wyTOvy (BYREF wy AS DOUBLE) AS INTEGER
    'Converte coordenada wy em coordenada vy
    WITH lg
        DIM vy AS INTEGER
        vy = CINT ( (wy - .wyMin) * fatorWyVy + .vyMin)
        RETURN vy
    END WITH
END FUNCTION
'---------------------------------------------------------------------------------------------------
FUNCTION vxTOwx (BYREF vx AS INTEGER) AS DOUBLE
    'Converte coordenada vx em coordenada wx
    WITH lg
        DIM wx AS DOUBLE
        wx = (vx - .vxMin) / fatorWxVx + .wxMin
        RETURN wx
    END WITH
END FUNCTION
'---------------------------------------------------------------------------------------------------
FUNCTION vyTOwy (BYREF vy AS INTEGER) AS DOUBLE
    'Converte coordenada vy em coordenada wy
    WITH lg
        DIM wy AS DOUBLE
        wy = (vy - .vyMin) / fatorWyVy + .wyMin
        RETURN wy
    END WITH
END FUNCTION
'---------------------------------------------------------------------------------------------------
'Os seguintes procedimentos so necessrios para inicializaes de variveis e da Tela Grfica, e
'para a plotagem dos pontos:
'---------------------------------------------------------------------------------------------------
SUB InicializaCoordsView
    DIM margem AS INTEGER
    DIM AS INTEGER rx,ry 'Resolucao da tela em pixeis
    DIM AS INTEGER depth  'color depth in bits
    
    ' Tela grafica com resolucao 640x480, 256 colors (8bits)
    'rx=640
    'ry=480 
    'depth = 8
    
    ' Tela grafica com resolucao 800x600, 256 colors (8bits)
    rx=800
    ry=600 
    depth = 8 
    
 
    SCREENRES (rx, ry, depth)
    'Color rgb(255,255,255),rgb(0,0,0)
    'Cls
    
    'Tamanho do caractere em pixeis
    lg.charSize=8'pixeis
    
    'Inicializa as variveis inteiras que definem os limites do grfico (em pixeis)
    margem = LEN("-0.00E-###") * lg.charSize
    'screen 11
    WITH lg
        .VxMin = margem
        .VxMax = rx-1-margem
        .VyMin = ry-1-margem
        .VyMax = margem
    END WITH
    'OBS: VyMin e VyMax definidos desta maneira, garantem que o eixo y
    'do grafico ira ser plotado em ordem crescente na direcao correta, ou seja, para cima
END SUB
'---------------------------------------------------------------------------------------------------
SUB InicializaCoordsWorld (BYVAL n AS INTEGER, x() AS DOUBLE, y() AS DOUBLE)
    'Inicializa as coordenadas World do usurio em variveis reais ( preciso double)
    WITH lg
        .WxMin = x(1)
        .WxMax = x(1)
        .WyMin = y(1)
        .WyMax = y(1)
        FOR i AS INTEGER = 2 TO n
            IF x(i) < .WxMin THEN .WxMin = x(i)
            IF x(i) > .WxMax THEN .WxMax = x(i)
            IF y(i) < .WyMin THEN .WyMin = y(i)
            IF y(i) > .WyMax THEN .WyMax = y(i)
        NEXT
    END WITH
END SUB
'---------------------------------------------------------------------------------------------------
SUB InicializaFatores
    'Este procedimento deve ser chamado
    'antes das FUNCTIONS de conversao de coordenadas world <---> view,
    'ou seja, antes da plotagem dos pontos
    WITH lg
        fatorWxVx = (.vxMax - .vxMin) / (.wxMax - .wxMin)
        fatorWyVy = (.vyMax - .vyMin) / (.wyMax - .wyMin)
    END WITH
END SUB
'---------------------------------------------------------------------------------------------------
'Este procedimento PlotarPontos  o nico procedimento que deve ser pblico, ou seja, a ser
'chamado pelo programa principal pois ele j executa automaticamente os procedimentos de
'inicializacao de variveis e da Tela grfica:
SUB PlotarPontos (BYVAL n AS INTEGER, x() AS DOUBLE, y() AS DOUBLE, BYVAL cor AS INTEGER, BYVAL flagLinhaUnindoPontos AS INTEGER, BYVAL titulos AS titulosDoGrafico)
    'Plota os n pontos com coordenadas armazenadas nos vetores x() e y()
    'cor: 9=azul; 10=verde; 11=ciano; 12=vermelho; 13=magenta; 14=amarelo; 15=branco
    
    DIM raio AS INTEGER = 5 'numero minimo de pixeis para boa definicao do circulo
    DIM  AS INTEGER Vx1, Vx2
    DIM  AS INTEGER Vy1, Vy2
    'Os seguintes procedimentos de inicializacao devem ser chamados
    'antes da plotagem dos pontos, nesta ordem:
    InicializaCoordsView
    InicializaCoordsWorld (n, x(), y())
    InicializaFatores
    
    
    colocarTicsERotulos (5)
    colocarTitulos (titulos)
    
    'Faz a moldura (limites das coords view) na tela grafica:
    LINE (lg.vxmin,lg.vymin)-(lg.vxmax,lg.vymax),15,B
    'Plota o primeiro ponto
    Vx1 = WxToVx (x(1))
    Vy1 = WyToVy (y(1))
    CIRCLE (Vx1,Vy1), raio, cor
    'Plota os demais pontos, ligando-os por um segmento de reta:
     FOR i AS INTEGER = 2 TO n
        'Segundo ponto
		Vx2 = WxToVx (x(i))
		Vy2 = WyToVy (y(i))
        IF flagLinhaUnindoPontos=1 THEN LINE (Vx1,Vy1) - (Vx2,Vy2), cor
		CIRCLE (Vx2,Vy2), raio, cor
		'Armazena o segundo ponto em variaveis1
		Vx1 = Vx2
		Vy1 = Vy2
	NEXT
END SUB 

SUB colocarTicsERotulos (BYREF numeroDeDivisoesNosEixos AS INTEGER)
    DIM ticSize AS INTEGER = 2
    DIM AS DOUBLE WxInc, WyInc 
    DIM nTics AS INTEGER
    DIM AS DOUBLE Wx, Wy
    DIM AS INTEGER Vx, Vy
    DIM S AS STRING
    
    'Eixo x
    WxInc = (lg.Wxmax - lg.Wxmin)/numeroDeDivisoesNosEixos
    nTics = numeroDeDivisoesNosEixos + 1
    FOR i AS INTEGER = 1 TO nTics
        Wy = lg.Wymin
        Wx = (i-1)*WxInc + lg.Wxmin
        Vx = WxTOVx(Wx)
        Vy = WyTOVy(Wy)
        'Tics no eixo x
        LINE (Vx,Vy-ticSize)-(Vx,Vy+ticSize)
        'Rotulos no eixo x
        'S = Str(Wx)
        S = FORMAT(Wx,"0.00E-###")
        DRAW STRING (Vx-8*LEN(S)/2,Vy+4),S
    NEXT i
    
    'Eixo y
    WyInc = (lg.Wymax - lg.Wymin)/numeroDeDivisoesNosEixos
    'nTics = numeroDeDivisoesNosEixos + 1
    FOR i AS INTEGER = 1 TO nTics
        Wx = lg.Wxmin
        Wy = (i-1)*WyInc + lg.Wymin
        Vx = WxTOVx(Wx)
        Vy = WyTOVy(Wy)
        LINE (Vx-ticSize,Vy)-(Vx+ticSize,Vy)
        'Rotulos no eixo y
        S = FORMAT(Wy,"0.00E-###")
        DRAW STRING (Vx-8*LEN(S)-ticSize,Vy-4),S
    NEXT
    
END SUB

SUB colocarTitulos(BYVAL titulos AS titulosDoGrafico)
    DIM AS INTEGER Vx, Vy
    
    'Titulo principal do grafico (na linha superior, no meio da tela)
    Vx=((lg.vxmax+lg.vxmin) - LEN(titulos.grafico)*lg.charSize)/2
    Vy=lg.charSize*3
    DRAW STRING(Vx,Vy),titulos.grafico
    
    'Titulo do eixo x
    Vx=((lg.vxmax+lg.vxmin) - LEN(titulos.eixoX)*lg.charSize)/2
    Vy=lg.Vymin+lg.charSize*2.5
    DRAW STRING (Vx,Vy),Titulos.eixoX
    
    'Titulo do eixo y
    Vx=lg.charSize 
    Vy=lg.VyMax-3*lg.charSize
    DRAW STRING (Vx,Vy), Titulos.eixoY
    
END SUB


SUB GraficoDeReta (BYVAL CoefLinear AS DOUBLE, BYVAL CoefAngular AS DOUBLE, BYVAL cor AS INTEGER)
    DIM n AS INTEGER = 2
    DIM AS DOUBLE Wx(2),Wy(2), Vx(2), Vy(2)
    
    'Clipping - cortando a reta que sai do limite do grafico
    'Primeiro ponto
    Wx(1) = lg.Wxmin
    Wy(1) = CoefLinear + CoefAngular*Wx(1)
    IF (Wy(1) < lg.Wymin) THEN
        Wy(1) = lg.Wymin
    END IF
    IF (Wy(1) > lg.Wymax) THEN
        Wy(1) = lg.Wymax
    END IF
    Wx(1) = (Wy(1)-CoefLinear)/CoefAngular
    
    'Clipping - cortando a reta que sai do limite do grafico
    'Segundo ponto
    Wx(2) = lg.Wxmax
    Wy(2) = CoefLinear + CoefAngular*Wx(2)
    IF (Wy(2) < lg.Wymin) THEN
        Wy(2) = lg.Wymin
    END IF
    IF (Wy(2) > lg.Wymax) THEN
        Wy(2) = lg.Wymax
    END IF
    Wx(2) = (Wy(2)-CoefLinear)/CoefAngular
    
    'Convertendo para coordenadas view
    Vx(1) = WxTOVx(Wx(1))
    Vx(2) = WxTOVx(Wx(2))
    Vy(1) = WyTOVy (Wy(1))
    Vy(2) = WyTOVy(Wy(2))
    
    'Plota a reta com clipping (dentro da moldura do grafico)
    LINE (Vx(1),Vy(1))- (Vx(2),Vy(2)), cor
    
END SUB

SUB LerCoordenadasComMouse
    
    DIM AS INTEGER Vx, Vy
    DIM AS DOUBLE Wx, Wy
    DIM AS INTEGER buttons
    DIM S AS STRING
    
    DO 
        'Le coordenadas view e botoes do mouse
        LerMouse (Vx, Vy, buttons)
        'Converte coordenadas view para coordenadas world
        Wx = VxTOWx(Vx)
        Wy = VyTOWy(Vy)
        'S = STR (CInt(Wx*1000)/1000) & "," & STR (CInt(Wy*1000)/1000)
        'S = FORMAT(Wx,"0.00E-###") & "," & FORMAT (Wy,"0.00E-###")
        S = Wx & " , " & Wy
        'Imprime na tela grafica na posicao de coordenadas view os valores da coordenada world
        LINE  (0,0)- (320,8),0,BF
        DRAW STRING (0,0), S
        SLEEP 10
    LOOP WHILE INKEY = ""
    
END SUB

