Print "**** Funcoes de Desenho 2D ****"
Print "Desenhando para 'buffers' de imagem"
Print "Pset e Preset, Line, Circle, Draw, Draw String, Paint"
Print "======================================================="
Print "PSet"
' Set an appropriate screen mode - 320 x 240 x 8bpp indexed color
ScreenRes 320, 240, 8
' Plot a pixel at the coordinates 100, 100, Color 15. (white)
PSet (100, 100), 15
' Confirm the operation.
Locate 1
print "PSet (100, 100), 15"
Print "Pixel plotted at 100, 100"
' Wait for a keypress.
getkey
 
' Plot another pixel at the coordinates 150, 150, Color 12. (magenta?) 
PSet (150, 150), 12
' Confirm the operation.
Locate 1
print "PSet (150, 150), 12"
Print "Pixel plotted at 150, 150"
' Wait for a keypress.
getkey
 
' Plot a third pixel relative to the second, Color 15. (white)
' This pixel is given the coordinates 60, 60. It will be placed
' at 60, 60 plus the previous coordinates (150, 150), thus plotting at 210, 210.
PSet Step (60, 60), 15
' Confirm the operation.
Locate 3
print "PSet Step (60, 60), 15"
Print "Pixel plotted at 150 + 60, 150 + 60"
' Wait for a keypress
getkey
Print "======================================================="
Screen 13
print "PReset"
'Set background color to 15
Color 0, 15
locate 1
print "Color , 15"
Print "Draw a pixel with the background color at 100, 100:"
print "PReset (100,100)"
PReset (100,100)
getkey
Print "Draw a pixel with the background color at Last x cord +10, Last y cord +10"
print "PReset Step (10,10)"
PReset Step (10,10)
getkey
Print "======================================================="
Screen 13
print "Line"
print "Draws a diagonal red line with a white box, and waits"
Line (20, 20)-(300, 180), 4  'red line
Line (140, 80)-(180, 120), 15, b 'white box
Line - ( 200, 200 ), 15 'line from last coord
getkey 
print "Line -----------"
ScreenRes 320, 240
print "Draws 2 lines with 2 different line styles in 2 different colors"

Line (10, 100)-(309, 140),  4, B, &b0100100100100100 ' red box with dashed border
Line (20, 115)-(299, 115),  9,  , &b1111000011111111 ' blue dashed line
Line (20, 125)-(299, 125), 10,  , &b0000111100000000 ' green dashed line

getkey
Print "======================================================="
' Set 640x480 mode, 256 colors
Screen 18
print "Circle"
' Draws a circle in the center
Circle (320, 240), 200, 15

' Draws a filled ellipse
Circle (320, 240), 200, 2, , , 0.2, F 
'centro=(,)  raio=200 cor=2 (verde)   aspecto=0.2  F=Fill mode

' Draws a small arc
Circle (320, 240), 200, 4, 0.83, 1.67, 3 '
'centro=(,)  raio=200 cor=4 (vermelho)   inicio=0.83  fim=1,67   aspecto=3
getkey



Print "======================================================="
Screen 13
print "Draw"
'Move to (50,50) without drawing
Draw "BM 50,50"
getkey

'Set drawing color to 2 (green)
Draw "C2"
'Draw a box
Draw "R50 D30 L50 U30"
getkey

'Move inside the box
Draw "BM +1,1"
getkey

'Flood fill (Paint) with color 1 (blue) up to border color 2 
Draw "P 1,2"
getkey

getkey
print "Draw-----------------"
'' Draws a flower on-screen

Dim As Integer i, a, c
Dim As String fill, setangle

'' pattern for each petal
Dim As Const String petal = _
    _
    ("X" & VarPtr(setangle)) _ '' link to angle-setting string
    _
    & "C15" _       '' set outline color (white)
    & "M+100,+10" _ '' draw outline
    "M +15,-10" _
    "M -15,-10" _
    "M-100,+10" _
    _
    & "BM+100,0" _              '' move inside petal
    & ("X" & VarPtr(fill)) _    '' flood-fill petal (by linking to fill string)
    & "BM-100,0"                '' move back out

'' set screen
ScreenRes 320, 240, 8
Print "Draw"
'' move to center
Draw "BM 160, 120"

'' set initial angle and color number
a = 0: c = 32

For i = 1 To 24

    '' make angle-setting and filling command strings
    setangle = "TA" & a
    fill = "P" & c & ",15"

    '' draw the petal pattern, which links to angle-setting and filling strings
    Draw petal
    
    '' short delay
    sleep 100

    '' increment angle and color number
    a += 15: c += 1

Next i

getkey
Print "======================================================="
Const w = 320, h = 200 '' screen dimensions

Dim x As Integer, y As Integer, s As String

'' Open a graphics window
ScreenRes w, h
print "Draw String"
'' Draw a string in the centre of the screen:

s = "Hello world"
x = (w - Len(s) * 8) \ 2   '116 pixel
y = (h - 1 * 8) \ 2         '96  pixel

Draw String (x, y), s

getkey
print "======================================="
print "Draw String"
'' Define character range
Const FIRSTCHAR = 32, LASTCHAR = 127

Const NUMCHARS = (LASTCHAR - FIRSTCHAR) + 1
Dim As UByte Ptr p, myFont
'Dim As Integer i

'' Open a 256 color graphics screen (320*200)
ScreenRes 320, 200, 8
print "Draw String"

'' Create custom font into PUT buffer
myFont = ImageCreate(NUMCHARS * 8, 9)
 '' Put font header at start of pixel data
#ifndef ImageInfo '' older versions of FB don't have the ImageInfo feature
p = myFont + IIf(myFont[0] = 7, 32, 4)
#else
ImageInfo( myFont, , , , , p )
#endif

p[0] = 0
p[1] = FIRSTCHAR
p[2] = LASTCHAR

 '' PUT each character into the font and update width information
For i = FIRSTCHAR To LASTCHAR
    
    '' Here we could define a custom width for each letter, but for simplicity we use
    '' a fixed width of 8 since we are reusing the default font glyphs
    p[3 + i - FIRSTCHAR] = 8
    
    '' Create character onto custom font buffer by drawing using default font
    Draw String myFont, ((i - FIRSTCHAR) * 8, 1), Chr(i), 32 + (i Mod 24) + 24
    
Next i

'' Now the font buffer is ready; we could save it using BSAVE for later use
Rem BSave "myfont.bmp", myFont

'-------------------------------------------------------
'' Here we draw a string using the custom font
Draw String (10, 10), "ABCDEFGHIJKLMNOPQRSTUVWXYZ", , myFont
Draw String (10, 26), "abcdefghijklmnopqrstuvwxyz", , myFont
Draw String (66, 58), "Hello world!", , myFont
'-------------------------------------------------------
'' Free the font from memory, now we are done with it
ImageDestroy myFont

getkey

Print "======================================================="
' draws a white circle painted blue inside
Screen 13
print "Paint"
print "Circle (160, 100), 30, 15"
print "Paint (160, 100), 1, 15"

Circle (160, 100), 30, 15
Paint (160, 100), 1, 15
getkey

print "Fim"
Print "======================================================="
getkey
