'Isto eh um exemplo de programa procedimental completo, 
'com todas as suas partes estruturadas
'
'Este programa faz o seguinte:
'1. Pergunta o numero de numeros inteiros que o usuario deseja somar (entrada de dados)
'2. O usuario entra os numeros inteiros no programa (entrada de dados)
'3. O programa calcula a soma dos numeros inteiros que o usuario digitou (calculos)
'4. O programa mostra na tela o resultado da soma dos numeros (saida de dados)
'5. Fim do programa
'
'
'****** Declaracoes de procedimentos e funcoes *********************************
Declare Sub entradaDeN (Byref n As Integer)
Declare Sub entradaDosNumeros (Byval n  As Integer, vetor() As Integer)
Declare Sub imprimirResultado(Byval numero As Integer)
Declare Function somaDosNumeros (vetor() As Integer) As Integer
'DECLARE sub somaDosNumeros (matriz() AS INTEGER, byref sum as integer)


'**** Programa principal *******************************************************


'Declaracao de variaveis do programa principal
Dim As Integer array()  'Posicoes de memoria onde serao armazenados
'                        os numeros digitados pelo usuario 
Dim As Integer n        'Quantidade de numeros entrado pelo usuario
Dim As Integer s        'Soma dos numeros  

Print "Programa para entrada de numeros inteiros e calculo da soma dos numeros"
Print

'Entrada de dados
entradaDeN (n)
entradaDosNumeros (n, array())


'Processamento/calculos
s= somaDosNumeros (array())' retorno da soma por function
'somaDosNumeros (array(),s)' retorno da soma por sub

'Saida de dados
imprimirResultado (s)

Print "Fim do programa (tecle algo para sair)"

'Sleep 
Getkey

End

'**** Fim do programa principal ***********************************************



'**** Definicoes de procedimentos e funcoes: **********************************

Sub entradaDeN (Byref n As Integer)
    'Byref pois n entrado pelo usuario deve ser retornado para o programa principal
    '(o conteudo da variavel n, do programa principal, pode ser modificada pela sub)
    
    Print "Qual a quantidade de numeros que deseja somar";
    Input n
    'alternativa:
    'INPUT "Qual a quantidade de numeros que deseja somar";n
    'sleep
End Sub


Sub entradaDosNumeros (Byval n As Integer, vetor() As Integer)
    'Byval n pois este valor nao sera modificado por esta sub
    'Obs: vetores e matrizes sao ***sempre*** passados por referencia e 
    'portanto nao necessitam explicitamente do comando byref
    
    'Declaracao de variavel local (do procedimento)
    Dim  As Integer i
    'redimensiona a matriz onde serao armazenados os numeros
    'pois o programa principal nao fez isso
    Redim vetor(1 to n) As Integer 
        
    For i=Lbound(vetor) To Ubound(vetor)
        'LBOUND e UBOUND = menor e maior indice do vetor
                
        Print "Entre com o "; i; Chr(248);" numero inteiro="; 
        'Chr(248) eh o simbolo 
        
        'Entrada dos numeros pelo teclado, armazenando na matriz:
        Input vetor(i)
    Next i
End Sub


Function somaDosNumeros (vetor() As Integer) As Integer
    'Declaracao de variaveis locais (da funcao)
    Dim As Integer i, sum
    
    sum=0
    For i=Lbound(vetor) To Ubound(vetor)
        sum = sum + vetor(i)
        'alternativa:
        'sum += vetor(i)
    Next i
    'Duas formas de retornar o resultado da funcao:
    'somaDosNumeros = sum
    Return sum
End Function



'Retorno de valor sum para o programa principal (BYREF sum AS INTEGER) 
'por meio de ****SUBrotina****
'SUB somaDosNumeros (vetor() AS INTEGER, BYREF sum as INTEGER)
'   'Declaracao de variaveis locais (da funcao)
'    DIM AS INTEGER i
'    
'    sum=0
'    FOR i=LBOUND(vetor) TO UBOUND(vetor)
'		sum = sum + vetor(i)
'        'alternativa:
'        'sum += vetor(i)
'    NEXT i
'END sub



Sub imprimirResultado(Byval numero As Integer)
    Print "Soma dos numeros=";numero
End Sub

'**** Fim das definicoes de procedimentos e funcoes ***************************


'**** Fim do programa *********************************************************


